/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.api.util.AEColor;
import appeng.block.AEBaseBlockItemChargeable;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.items.misc.CrystalSeedItem;
import appeng.items.tools.powered.ColorApplicatorItem;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public final class InitItemModelsProperties {
    public static final ResourceLocation GROWTH_PREDICATE_ID = AppEng.makeId("growth");
    public static final ResourceLocation COLORED_PREDICATE_ID = AppEng.makeId("colored");
    public static final ResourceLocation ENERGY_FILL_LEVEL_ID = AppEng.makeId("fill_level");

    private InitItemModelsProperties() {
    }

    public static void init() {
        ColorApplicatorItem colorApplicatorItem = AEItems.COLOR_APPLICATOR.m_5456_();
        ItemProperties.register((Item)colorApplicatorItem, (ResourceLocation)COLORED_PREDICATE_ID, (itemStack, level, entity, seed) -> {
            AEColor col = colorApplicatorItem.getActiveColor(itemStack);
            return col != null ? 1.0f : 0.0f;
        });
        InitItemModelsProperties.registerSeedGrowth(AEItems.CERTUS_CRYSTAL_SEED);
        InitItemModelsProperties.registerSeedGrowth(AEItems.FLUIX_CRYSTAL_SEED);
        ForgeRegistries.ITEMS.forEach(item -> {
            if (!(item instanceof AEBaseBlockItemChargeable)) {
                return;
            }
            AEBaseBlockItemChargeable chargeable = (AEBaseBlockItemChargeable)item;
            ItemProperties.register((Item)chargeable, (ResourceLocation)ENERGY_FILL_LEVEL_ID, (is, level, entity, seed) -> {
                double curPower = chargeable.getAECurrentPower(is);
                double maxPower = chargeable.getAEMaxPower(is);
                return (int)Math.round(100.0 * curPower / maxPower);
            });
        });
    }

    private static void registerSeedGrowth(ItemDefinition<?> definition) {
        ItemProperties.register(definition.m_5456_(), (ResourceLocation)GROWTH_PREDICATE_ID, (is, level, p, s) -> (float)CrystalSeedItem.getGrowthTicks(is) / 24000.0f);
    }
}

